<?php

namespace Layerdrops\Ogency\Widgets;


class Video extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-video';
    }

    public function get_title()
    {
        return __('Video', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    // 'layout_two' => __('Layout Two', 'ogency-addon'),
                    // 'layout_three' => __('Layout Three', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include ogency_get_elementor_option('video-one-option.php');
        // include ogency_get_elementor_option('video-two-option.php');
        // include ogency_get_elementor_option('video-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Rounded Text Title', '{{WRAPPER}} .video-one__banner__curved-circle-box .curved-circle', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('video-one.php');
        // include ogency_get_template('video-two.php');
        // include ogency_get_template('video-three.php');
    }
}
