<?php

namespace Layerdrops\Ogency\Widgets;


class MainSlider extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-main-slider';
    }

    public function get_title()
    {
        return __('Main Slider', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    'layout_three' => __('Layout Three', 'ogency-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include ogency_get_elementor_option('main-slider-one-option.php');
        include ogency_get_elementor_option('main-slider-two-option.php');
        include ogency_get_elementor_option('main-slider-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .main-slider__one-item__content h2,{{WRAPPER}} .hero-banner__content__title.wow.fadeInUp.animated', ['layout_one', 'layout_two', 'layout_three']);
        ogency_elementor_general_style_options($this, 'Number', '{{WRAPPER}} .main-slider .main-slider__phone', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Subtitle', '{{WRAPPER}} .hero-banner__bottom__text', ['layout_three']);
        ogency_elementor_general_style_options($this, 'Highlighted Text', '{{WRAPPER}} .hero-banner__bottom__title span', ['layout_three']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .main-slider__btn-one, {{WRAPPER}} .main-slider-two__btn-one', '{{WRAPPER}} .thm-btn::before', ['layout_one', 'layout_two', 'layout_three']);
        ogency_elementor_button_style_options($this, 'Button Two', '{{WRAPPER}} .main-slider__btn-two.thm-btn, {{WRAPPER}} .main-slider-two__btn-two.thm-btn', '{{WRAPPER}} .thm-btn::before,{{WRAPPER}} .main-slider-two__btn-two.thm-btn:before', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        ogency_get_elementor_carousel_options($this, ['layout_one', 'layout_two']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('main-slider-one.php');
        include ogency_get_template('main-slider-two.php');
        include ogency_get_template('main-slider-three.php');
    }
}
