<?php

namespace Layerdrops\Ogency\Widgets;


class ImageBox extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'ogency-image-box';
	}

	public function get_title()
	{
		return __('Image Box', 'ogency-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['ogency-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'ogency-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'ogency-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'ogency-addon'),
				]
			]
		);

		$this->end_controls_section();

		include ogency_get_elementor_option('image-box-one-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'ogency-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .services-details__benefit__title', ['layout_one']);
		ogency_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .services-details__benefit__text', ['layout_one']);
		ogency_elementor_general_style_options($this, 'Check List', '{{WRAPPER}} .services-details__benefit__lists li', ['layout_one', 'layout_two']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include ogency_get_template('image-box-one.php');
	}
}
