<?php

namespace Layerdrops\Ogency\Widgets;


class Feature extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-feature';
    }

    public function get_title()
    {
        return __('Feature', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon')
                ]
            ]
        );


        $this->end_controls_section();

        include ogency_get_elementor_option('feature-one-option.php');
        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .feature-one__item__content--title', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .feature-one__item__hover-content--text', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Button Label', '{{WRAPPER}} .feature-one__item__hover-content__btn', ['layout_one']);


        $this->end_controls_section();
        ogency_elementor_column_count_options($this, ['layout_one', 'layout_two']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('feature-one.php');
    }
}
