<?php

namespace Layerdrops\Ogency\Widgets;


class CallToAction extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-call-to-action';
    }

    public function get_title()
    {
        return __('Call To Action', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    // 'layout_three' => __('Layout Three', 'ogency-addon'),
                ]
            ]
        );
        $this->end_controls_section();

        include ogency_get_elementor_option('call-to-action-one-option.php');
        include ogency_get_elementor_option('call-to-action-two-option.php');
        // include ogency_get_elementor_option('call-to-action-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .cta-one__text,{{WRAPPER}} .cta-two .section-title h2', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        ogency_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .cta-one__icon,{{WRAPPER}} .ogency-btn', '{{WRAPPER}} .cta-one__author .cta-one__icon:hover, {{WRAPPER}} .ogency-btn::after', ['layout_one', 'layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('call-to-action-one.php');
        include ogency_get_template('call-to-action-two.php');
        // include ogency_get_template('call-to-action-three.php');
    }
}
