<?php

namespace Layerdrops\Ogency\Widgets;


class Blog extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-blog';
    }

    public function get_title()
    {
        return __('Blog', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    'layout_three' => __('Layout Three', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include  ogency_get_elementor_option('blog-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one']);

        ogency_elementor_general_style_options($this, 'Post Title', '{{WRAPPER}} .blog-one__item__title a', ['layout_one', 'layout_two', 'layout_three']);
        ogency_elementor_general_style_options($this, 'Post Meta', '{{WRAPPER}} .blog-one__item__meta a,{{WRAPPER}} .blog-one__item__content .comments-link i', ['layout_one', 'layout_two', 'layout_three']);

        ogency_elementor_general_style_options($this, 'Post Date', '{{WRAPPER}} .blog-one__item__image span', ['layout_one', 'layout_two', 'layout_three']);
        ogency_elementor_general_style_options($this, 'Read More', '{{WRAPPER}} .blog-one__item__btn', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();

        ogency_elementor_column_count_options($this, ['layout_one', 'layout_two']);
        ogency_get_elementor_carousel_options($this, ['layout_three']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('blog-one.php');
        include ogency_get_template('blog-two.php');
        include ogency_get_template('blog-three.php');
    }
}
