<?php

namespace Layerdrops\Ogency;

class Customizer
{
    public function __construct()
    {
        add_action("customize_register", [$this, 'ogency_customizer']);
    }
    public function ogency_customizer($wp_customize)
    {

        // add panel
        $wp_customize->add_panel(
            'ogency_theme_opt',
            array(
                'title'      => esc_html__('Ogency Options', 'ogency-addon'),
                'description' => esc_html__('Ogency Theme options panel', 'ogency-addon'),
                'priority'   => 220,
                'capability' => 'edit_theme_options',
            )
        );

        // General Settings
        $wp_customize->add_section('ogency_theme_general', array(
            'title' => __('General Settings', 'ogency-addon'),
            'description' => esc_html__('Ogency General Settings.', 'ogency-addon'),
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'panel'      => 'ogency_theme_opt'
        ));


        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Base color', 'ogency-addon'),
            'ogency_theme_general',
            'theme_base_color',
            '#f5900d'
        );

        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Primary color', 'ogency-addon'),
            'ogency_theme_general',
            'theme_primary_color',
            '#f2edea'
        );

        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Secondary color', 'ogency-addon'),
            'ogency_theme_general',
            'theme_secondary_color',
            '#5b4034'
        );

        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Black color', 'ogency-addon'),
            'ogency_theme_general',
            'theme_black_color',
            '#000000'
        );


        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Dark Mode?', 'ogency-addon'),
            'ogency_theme_general',
            'ogency_dark_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Boxed Mode?', 'ogency-addon'),
            'ogency_theme_general',
            'ogency_boxed_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Rtl Mode?', 'ogency-addon'),
            'ogency_theme_general',
            'ogency_rtl_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Custom Cursor', 'ogency-addon'),
            'ogency_theme_general',
            'custom_cursor',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Back to top?', 'ogency-addon'),
            'ogency_theme_general',
            'scroll_to_top',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Back to top icon', 'ogency-addon'),
            'ogency_theme_general',
            'scroll_to_top_icon',
            'fa-angle-up',
            ogency_get_fa_icons(),
            function () {
                return (get_theme_mod('scroll_to_top', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Preloader?', 'ogency-addon'),
            'ogency_theme_general',
            'preloader',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Custom Preloader Image', 'ogency-addon'),
            'ogency_theme_general',
            'preloader_image',
            '',
            function () {
                return (get_theme_mod('preloader', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Page Header Background Image', 'ogency-addon'),
            'ogency_theme_general',
            'page_header_bg_image'
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Page Header Overlay Image', 'ogency-addon'),
            'ogency_theme_general',
            'page_header_overlay_image'
        );

        // Blog Layout
        $wp_customize->add_section('ogency_blog_layout_settings', array(
            'title' => __('Blog Layout', 'ogency-addon'),
            'description' => esc_html__('Ogency Blog Layout', 'ogency-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'ogency_theme_opt'
        ));

        $this->customize_type_select(
            $wp_customize,
            'Select Sidebar position',
            'ogency_blog_layout_settings',
            'ogency_blog_layout',
            'right-align',
            array(
                'left-align' => esc_html__('Left Align', 'ogency-addon'),
                'right-align' => esc_html__('Right Align', 'ogency-addon'),
                'full-width' => esc_html__('Full Width', 'ogency-addon'),
            )
        );

        // Shop Layout
        $wp_customize->add_section('ogency_shop_layout_settings', array(
            'title' => __('Shop Layout', 'ogency-addon'),
            'description' => esc_html__('Ogency Shop Layout', 'ogency-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'ogency_theme_opt'
        ));


        $this->customize_type_select(
            $wp_customize,
            'Select Shop position',
            'ogency_shop_layout_settings',
            'ogency_shop_layout',
            '3',
            array(
                '2' => esc_html__('2 Column', 'ogency-addon'),
                '3' => esc_html__('3 Column', 'ogency-addon'),
                '4' => esc_html__('4 Column', 'ogency-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            'Select Shop Sidebar position',
            'ogency_shop_layout_settings',
            'ogency_shop_sidebar_layout',
            'left-align',
            array(
                'left-align' => esc_html__('Left Align', 'ogency-addon'),
                'right-align' => esc_html__('Right Align', 'ogency-addon'),
                'full-width' => esc_html__('Full Width', 'ogency-addon'),
            )
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Shop Product Per page', 'ogency-addon'),
            'ogency_shop_layout_settings',
            'product_per_page',
            esc_html(12)
        );

        // Header options
        $wp_customize->add_section('ogency_theme_header', array(
            'title' => __('Header Settings', 'ogency-addon'),
            'description' => esc_html__('Ogency Header Settings', 'ogency-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'ogency_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Add Logo size in px', 'ogency-addon'),
            'ogency_theme_header',
            'header_logo_width',
            esc_html(198)
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Sticky Header?', 'ogency-addon'),
            'ogency_theme_header',
            'header_sticky_menu',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Breadcrumb?', 'ogency-addon'),
            'ogency_theme_header',
            'breadcrumb_opt',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Header?', 'ogency-addon'),
            'ogency_theme_header',
            'header_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Header Type', 'ogency-addon'),
            'ogency_theme_header',
            'header_custom_post',
            '',
            ogency_post_query('header'),
            function () {
                return (get_theme_mod('header_custom', 'no') == 'yes' ? true : false);
            }
        );

        //  Mobile Menu
        $wp_customize->add_section('ogency_theme_mobile_menu', array(
            'title' => esc_html__('Mobile Menu Settings', 'ogency-addon'),
            'description' => esc_html__('Ogency Header Settings', 'ogency-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'ogency_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Email', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'ogency_mobile_menu_email',
            esc_html__('needhelp@ogency.com', 'ogency-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Phone', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'ogency_mobile_menu_phone',
            esc_html__('666 888 0000', 'ogency-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Facebook url', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'facebook_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Twitter url', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'twitter_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Linkedin url', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'linkedin_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Pinterest url', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'pinterest_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Youtube url', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'youtube_url',
        );


        $this->customize_type_text(
            $wp_customize,
            esc_html__('dribbble url', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'dribble_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Instagram url', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'instagram_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Reddit url', 'ogency-addon'),
            'ogency_theme_mobile_menu',
            'reddit_url',
        );

        // Footer options
        $wp_customize->add_section('ogency_theme_footer', array(
            'title' => esc_html__('Footer Settings', 'ogency-addon'),
            'description' => esc_html__('Ogency Footer Settings.', 'ogency-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'ogency_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Footer Text', 'ogency-addon'),
            'ogency_theme_footer',
            'footer_copytext',
            esc_html__('&copy; All right reserved', 'ogency'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? false : true);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Footer ?', 'ogency-addon'),
            'ogency_theme_footer',
            'footer_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Footer Type', 'ogency-addon'),
            'ogency_theme_footer',
            'footer_custom_post',
            '',
            ogency_post_query('footer'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? true : false);
            }
        );

        // register
        $wp_customize->add_section('ogency_login_settings', array(
            'title' => __('Login/Register Settings', 'ogency-addon'),
            'description' => esc_html__('Login/Register Settings', 'ogency-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'ogency_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Redirect url After Login', 'ogency-addon'),
            'ogency_login_settings',
            'login_redirect_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Redirect url After Registration', 'ogency-addon'),
            'ogency_login_settings',
            'registration_redirect_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Redirect url After Log Out', 'ogency-addon'),
            'ogency_login_settings',
            'logout_redirect_url',
        );

        // error page
        $wp_customize->add_section('ogency_error_page_settings', array(
            'title' => __('404 Settings', 'ogency-addon'),
            'description' => esc_html__('Change 404 Text', 'ogency-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'ogency_theme_opt'
        ));

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom 404 ?', 'ogency-addon'),
            'ogency_error_page_settings',
            'error_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'ogency-addon'),
                'no' => esc_html__('No', 'ogency-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select 404 Page', 'ogency-addon'),
            'ogency_error_page_settings',
            'error_custom_post',
            '',
            ogency_post_query('page'),
            function () {
                return (get_theme_mod('error_custom', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('404 Page Title Image', 'ogency-addon'),
            'ogency_error_page_settings',
            '404_page_title_image'
        );
    }

    //type text
    public function customize_type_text($wp_customize, $label, $section_id, $name,  $default = "", $callback = null)
    {
        // add settings
        $wp_customize->add_setting($name, array(
            'default'  => $default,
            'type'     => 'theme_mod'
        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "text",
                "active_callback" => $callback,
            )
        ));
    }


    //type color
    public function customize_type_color($wp_customize, $label, $section_id, $name,  $default)
    {
        // add settings
        $wp_customize->add_setting($name, array(
            'default'  => sanitize_hex_color($default),
            'type'     => 'theme_mod'
        ));

        // Add control
        $wp_customize->add_control(new \WP_Customize_Color_Control($wp_customize, $name, array(
            'label'    => $label,
            'section'  => $section_id,
            'setting' => $name,
            'priority' => 1
        )));
    }

    // type checkbox
    public function customize_type_checkbox($wp_customize, $label, $section_id, $name,  $default, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "checkbox",
                "active_callback" => $callback,
            )
        ));
    }

    // type Image
    public function customize_type_image($wp_customize, $label, $section_id, $name,  $default = '', $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Upload_Control($wp_customize, $name, array(
            'label'    => $label,
            'section'  => $section_id,
            'setting' => $name,
            'priority' => 20,
            "active_callback" => $callback,
        )));
    }

    public function customize_type_select($wp_customize, $label, $section_id, $name,  $default, $select_value,  $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "select",
                'choices'     => $select_value,
                "active_callback" => $callback,
            )
        ));
    }

    public function customize_type_radio($wp_customize, $label, $section_id, $name,  $default, $radio_value, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "radio",
                'choices'     => $radio_value,
                "active_callback" => $callback,
            )
        ));
    }
}
