<?php

namespace Layerdrops\Ogency;

class Assets
{

    /**
     * Class constructor
     */
    function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'register_assets']);
        add_action('admin_enqueue_scripts', [$this, 'register_assets']);
    }

    /**
     * All available scripts
     *
     * @return array
     */
    public function get_scripts()
    {
        return [
            'bootstrap-select' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/bootstrap-select/js/bootstrap-select.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/bootstrap-select/js/bootstrap-select.min.js'),
                'deps'    => ['jquery', 'bootstrap']
            ],
            'jquery-bxslider' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.min.js'),
                'deps'    => ['jquery']
            ],
            'countdown' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/countdown/countdown.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/countdown/countdown.min.js'),
                'deps'    => ['jquery']
            ],
            'jarallax' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/jarallax/jarallax.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/jarallax/jarallax.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-ajaxchimp' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-appear' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/jquery-appear/jquery.appear.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/jquery-appear/jquery.appear.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-circle-progress' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/jquery-circle-progress/jquery.circle-progress.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/jquery-circle-progress/jquery.circle-progress.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-magnific-popup' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js'),
                'deps'    => ['jquery']
            ],
            'odometer' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/odometer/odometer.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/odometer/odometer.min.js'),
                'deps'    => ['jquery']
            ],
            'owl-carousel' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.js'),
                'deps'    => ['jquery']
            ],
            'swiper' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/swiper/swiper.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/swiper/swiper.min.js'),
                'deps'    => ['jquery']
            ],
            'wow' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/wow/wow.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/wow/wow.js'),
                'deps'    => ['jquery']
            ],

            'sharer' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/sharer/sharer.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/sharer/sharer.min.js'),
                'deps'    => ['jquery']
            ],

            'tiny-slider' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/tiny-slider/tiny-slider.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/tiny-slider/tiny-slider.min.js'),
                'deps'    => ['jquery']
            ],

            'circletype' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/circleType/jquery.circleType.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/circleType/jquery.circleType.js'),
                'deps'    => ['jquery']
            ],

            'circleletter' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/circleType/jquery.lettering.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/circleType/jquery.lettering.min.js'),
                'deps'    => ['jquery']
            ],
            'select2' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/select2/js/select2.min.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/select2/js/select2.min.js'),
                'deps'    => ['jquery']
            ],
            'timepicker' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/timepicker/timePicker.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/timepicker/timePicker.js'),
                'deps'    => ['jquery']
            ],
            'ogency-addon-customizer' => [
                'src'     => OGENCY_ADDON_ASSETS . '/js/ogency-addon-customizer.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/js/ogency-addon-customizer.js'),
                'deps'    => ['jquery', 'select2']
            ],
            'ogency-addon-script' => [
                'src'     => OGENCY_ADDON_ASSETS . '/js/ogency-addon.js',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/js/ogency-addon.js'),
                'deps'    => ['jquery']
            ]
        ];
    }

    /**
     * All available styles
     *
     * @return array
     */
    public function get_styles()
    {
        return [
            'animate' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/animate/animate.min.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/animate/animate.min.css')
            ],
            'custom-animate' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/animate/custom-animate.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/animate/custom-animate.css')
            ],
            'bootstrap-select' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/bootstrap-select/css/bootstrap-select.min.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/bootstrap-select/css/bootstrap-select.min.css')
            ],
            'bxslider' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.css')
            ],
            'jarallax' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/jarallax/jarallax.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/jarallax/jarallax.css')
            ],
            'jquery-magnific-popup' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css')
            ],
            'odometer' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/odometer/odometer.min.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/odometer/odometer.min.css')
            ],
            'tiny-slider' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/tiny-slider/tiny-slider.min.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/tiny-slider/tiny-slider.min.css')
            ],
            'owl-carousel' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.css')
            ],
            'owl-theme' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/owl-carousel/owl.theme.default.min.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/owl-carousel/owl.theme.default.min.css')
            ],
            'reey-font' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/reey-font/stylesheet.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/reey-font/stylesheet.css')
            ],
            'alagambe-font' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/alagambe-font/stylesheet.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/alagambe-font/stylesheet.css')
            ],
            'swiper' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/swiper/swiper.min.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/swiper/swiper.min.css')
            ],
            'select2' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/select2/css/select2.min.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/select2/css/select2.min.css')
            ],
            'jquery-ui' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/jquery-ui/jquery-ui.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/jquery-ui/jquery-ui.css')
            ],
            'timepicker' => [
                'src'     => OGENCY_ADDON_ASSETS . '/vendors/timepicker/timePicker.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/vendors/timepicker/timePicker.css')
            ],
            'ogency-addon-style' => [
                'src'     => OGENCY_ADDON_ASSETS . '/css/ogency-addon.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/css/ogency-addon.css')
            ],
            'ogency-addon-admin-style' => [
                'src'     => OGENCY_ADDON_ASSETS . '/css/ogency-addon-admin.css',
                'version' => filemtime(OGENCY_ADDON_PATH . '/assets/css/ogency-addon-admin.css')
            ]
        ];
    }

    /**
     * Register scripts and styles
     *
     * @return void
     */
    public function register_assets()
    {
        $scripts = $this->get_scripts();
        $styles  = $this->get_styles();

        foreach ($scripts as $handle => $script) {
            $deps = isset($script['deps']) ? $script['deps'] : false;

            wp_register_script($handle, $script['src'], $deps, $script['version'], true);
        }

        foreach ($styles as $handle => $style) {
            $deps = isset($style['deps']) ? $style['deps'] : false;

            wp_register_style($handle, $style['src'], $deps, $style['version']);
        }
    }
}
