<?php if ('layout_two' === $settings['layout_type']) : ?>

    <!--Testimonial Two Start-->
    <section class="testimonial-two">
        <div class="testimonial-two__bg" style="background-image: url(<?php echo esc_url($settings['layout_shape_bg_image']['url']); ?>);"></div>
        <div class="container">
            <div class="testimonial-two__carousel__wrapper">
                <!-- Testimonial Thumb -->
                <ul class="testimonial-two__carousel__thumb" id="testimonial-two__carousel__thumb">
                    <?php foreach ($settings['layout_two_testimonials'] as $index => $item) :  ?>
                        <li class="testimonial-two__carousel__thumb__item">
                            <?php ogency_elementor_rendered_image($item, 'image'); ?>
                        </li><!-- Testimonial Thumb Item -->
                    <?php endforeach; ?>
                </ul>
                <!-- Testimonial Thumb -->
                <!-- Testimonial Content -->
                <div class="testimonial-two__carousel ogency-tiny__slider" id="testimonial-two__carousel" data-tiny-options='{
                "container": "#testimonial-two__carousel",
                "items": 1,
                "loop": true,
                "slideBy": "page",
                "gutter": 0,
                "mouseDrag": true,
                "autoplay": true,
                "autoplayTimeout": 2000,
                "speed": 400,
                "navContainer": "#testimonial-two__carousel__thumb",
                "controlsContainer": false,
                "autoplayButtonOutput": false,
                "navAsThumbnails": true
                }'>
                    <?php foreach ($settings['layout_two_testimonials'] as $index => $item) :  ?>
                        <!-- Testimonial Item -->
                        <div class="testimonial-two__item">
                            <div class="testimonial-two__item__quote">
                                <?php echo wp_kses($item['testimonial'], 'ogency_allowed_tags'); ?>
                            </div><!-- testimonial-quote -->
                            <div class="testimonial-two__item__meta"><?php echo wp_kses($item['name'], 'ogency_allowed_tags'); ?><?php echo wp_kses($item['designation'], 'ogency_allowed_tags'); ?></div><!-- testimonial-meta -->
                        </div>
                        <!-- Testimonial Item -->
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section>
    <!--Testimonial Two End-->
<?php endif; ?>