<?php if ('layout_one' === $settings['layout_type']) : ?>
    <!-- Team Details -->
    <section class="team-details">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 wow fadeInUp animated" data-wow-delay="300ms">
                    <div class="team-details__image">
                        <?php ogency_elementor_rendered_image($settings, 'bg_image'); ?>
                    </div><!-- /.team-image -->
                </div>
                <div class="col-lg-6 wow fadeInUp animated" data-wow-delay="400ms">
                    <div class="team-details__content">
                        <?php
                        if (!empty($settings['name'])) :
                            $this->add_inline_editing_attributes('name', 'none');
                            ogency_elementor_rendered_content($this, 'name', 'team-details__title', $settings['name_tag_layout_one']);
                        endif;

                        if (!empty($settings['designation'])) :
                            $this->add_inline_editing_attributes('designation', 'none');
                            ogency_elementor_rendered_content($this, 'designation', 'team-details__designation', 'span');
                        endif;
                        ?>
                        <div class="team-details__social">
                            <?php foreach ($settings['social_icons'] as $item) : ?>
                                <a href="<?php echo esc_url($item['social_url']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?></a>
                            <?php endforeach; ?>
                        </div><!-- /.team-social -->
                        <?php
                        if (!empty($settings['summary'])) :
                            ogency_basic_rendered_content($this, $settings,  'summary', 'team-details__text', 'p');
                        endif;

                        if (!empty($settings['point_list_title'])) :
                            ogency_basic_rendered_content($this, $settings,  'point_list_title', 'team-details__heading', $settings['point_title_tag_layout_one']);
                        endif;
                        ?>
                        <ul class="team-details__lists clearfix">
                            <?php foreach ($settings['point_list'] as $index => $item) : ?>
                                <li> <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?><?php echo wp_kses($item['title'], 'ogency_allowed_tags'); ?></li>
                            <?php endforeach; ?>
                        </ul><!-- /.list -->
                        <?php foreach ($settings['progress_list'] as $index => $item) : ?>
                            <div class="team-details__progress">
                                <?php
                                if (!empty($item['title'])) :
                                    ogency_basic_rendered_content($this, $item,  'title', 'team-details__progress--title', 'h4');
                                endif;
                                ?>
                                <div class="team-details__progress--bar">
                                    <div class="team-details__progress--inner count-bar" data-percent="<?php echo esc_attr($item['number']); ?>">
                                        <div class="team-details__progress--number count-text"><?php echo esc_attr($item['number']); ?></div>
                                    </div>
                                </div>
                            </div><!-- /.skills-item -->
                        <?php endforeach; ?>
                    </div><!-- /.team-details-content -->
                </div>
            </div>
        </div>
    </section>
    <!-- Team Details -->
<?php endif; ?>