<?php if ('layout_three' === $settings['layout_type']) : ?>
	<!-- Service Three Start -->
	<section class="service-three">
		<div class="container">
			<div class="row">
				<div class="col-md-7">
					<div class="section-title">
						<?php
						if (!empty($settings['layout_three_sec_sub_title'])) :
							$this->add_inline_editing_attributes('layout_three_sec_sub_title', 'none');
							ogency_elementor_rendered_content($this, 'layout_three_sec_sub_title', 'section-title__tagline section-title__tagline--has-dots', $settings['section_sub_title_tag_layout_three']);
						endif;

						if (!empty($settings['layout_three_sec_title'])) :
							$this->add_inline_editing_attributes('layout_three_sec_title', 'none');
							ogency_elementor_rendered_content($this, 'layout_three_sec_title', 'section-title__title', $settings['section_title_tag_layout_three']);
						endif;
						?>
					</div><!-- section-title -->
				</div>
				<div class="col-md-5">
					<?php
					if (!empty($settings['layout_three_sec_summary'])) :
						$this->add_inline_editing_attributes('layout_three_sec_summary', 'none');
						ogency_elementor_rendered_content($this, 'layout_three_sec_summary', 'service-three__text', 'p');
					endif;
					?>
				</div>
			</div>
		</div>
		<div class="container service-three__container">
			<div class="row">
				<?php
				$i = 1;
				foreach ($settings['layout_three_service_items'] as $index => $item) :
				?>
					<div class="col-xl-3 col-md-6 wow fadeInUp animated" data-wow-delay="100ms">
						<div class="service-three__item">
							<div class="service-three__item__thumb">
								<?php ogency_elementor_rendered_image($item, 'image'); ?>
							</div><!-- /.service-image -->
							<div class="service-three__item__normal">
								<?php
								if (!empty($item['title'])) :
									ogency_basic_rendered_content($this, $item,  'title', 'service-three__item__normal__title', $item['service_title_tag_layout_three']);
								endif;
								?>
							</div><!-- /.service-normal-content -->
							<div class="service-three__item__hover">
								<<?php echo esc_attr($item['service_title_tag_layout_three']); ?> class="service-three__item__hover__title">
									<?php
									if (!empty($item['title'])) :
										ogency_basic_rendered_content($this, $item,  'title', '', 'a');
									endif;
									?>
								</<?php echo esc_attr($item['service_title_tag_layout_three']); ?>><!-- /.service-title -->
								<?php
								if (!empty($item['subtitle'])) :
									ogency_basic_rendered_content($this, $item,  'subtitle', 'service-three__item__hover__text', 'p');
								endif;
								?>
								<?php if (!empty($item['btn_text'])) : ?>
									<a class="service-three__item__hover__btn" href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['btn_text']); ?><?php \Elementor\Icons_Manager::render_icon($item['btn_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a><!-- /.service-read-more -->
								<?php endif; ?>
							</div><!-- /.service-hover-content -->
						</div><!-- /.service-card-three -->
					</div><!-- /.column -->
				<?php
				endforeach; ?>
			</div>
		</div>
	</section>
	<!-- Service Three  Start -->
<?php endif; ?>