<?php if ('layout_two' === $settings['layout_type']) : ?>
	<!--Main Slider Start-->
	<section class="main-slider">
		<div class="main-slider__two ogency-owl__carousel owl-carousel" data-owl-options='{
		"loop": <?php echo esc_attr(('yes' == $settings['loop']) ? 'true' : 'false'); ?>,
		"animateOut": "slideOutDown",
		"animateIn": "fadeIn",
		"items": <?php echo esc_attr($settings['items']['size']); ?>,
		"autoplay": 6000,
		"autoplayTimeout": 7000,
		"smartSpeed": 1000,
		"nav": false,
        "navText": ["<span class=\"icon-left-arrow\"></span>","<span class=\"icon-right-arrow\"></span>"],
		"dots": true,
		"margin": 0
	    }'>
			<?php
			$i = 1;
			foreach ($settings['layout_two_sliders'] as $slider) : ?>
				<div class="item">
					<!-- slider item start -->
					<div class="main-slider__two__item">
						<!-- bg image start -->
						<div class="main-slider__two__bg" style="background-image: url(<?php echo esc_url($slider['background_image']['url']); ?>);"></div>
						<!-- bg image end -->
						<!-- bg image overlay start -->
						<div class="main-slider__two__overlay" style="background-image: url(<?php echo esc_url($slider['overlay_image']['url']); ?>);"></div>
						<!-- bg image overlay end -->
						<div class="container">
							<div class="row">
								<div class="col-xl-12">
									<div class="main-slider__two__content text-center">
										<div class="main-slider__two__dots"><span></span><span></span></div><!-- slider-dots -->
										<h2 class="main-slider__two__content__title">
											<?php echo wp_kses($slider['title_before'], 'ogency_allowed_tags'); ?><a href="<?php echo esc_url($slider['video_url']['url']); ?>" class="video-popup">
												<?php ogency_elementor_rendered_image($slider, 'video_image'); ?>
												<span class="fa fa-play"></span>
											</a><?php echo wp_kses($slider['title_after'], 'ogency_allowed_tags'); ?><a href="<?php echo esc_url($slider['url']['url']); ?>" class="main-slider__two__btn"><?php \Elementor\Icons_Manager::render_icon($slider['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a><!-- slider-btn -->
										</h2><!-- slider-title -->
									</div>
								</div>
							</div>
						</div>
					</div>
				</div><!-- slider item end -->
			<?php $i++;
			endforeach; ?>
		</div>
	</section>
	<!--Main Slider End-->


<?php endif; ?>