<?php if ('layout_one' === $settings['layout_type']) : ?>
    <!--Main Slider Start-->
    <section class="main-slider">
        <div class="main-slider__one ogency-owl__carousel owl-carousel" data-owl-options='{
		"loop": <?php echo esc_attr(('yes' == $settings['loop']) ? 'true' : 'false'); ?>,
		"animateOut": "fadeOut",
		"animateIn": "fadeIn",
		"items": <?php echo esc_attr($settings['items']['size']); ?>,
		"autoplay": 6000,
		"autoplayTimeout": 7000,
		"smartSpeed": 500,
		"nav": false,
		"dots": false,
		"margin": 0
	    }'>
            <?php
            foreach ($settings['sliders'] as $index => $slider) :
            ?>
                <div class="item">
                    <!-- slider item start -->
                    <div class="main-slider__one-item">
                        <!-- bg image start -->
                        <div class="main-slider__one-bg" style="background-image: url(<?php echo esc_url($slider['background_image']['url']); ?>);"></div>
                        <!-- bg image end -->
                        <!-- image-layer start -->
                        <div class="main-slider__one-item__shape-1">
                            <?php ogency_elementor_rendered_image($slider, 'shape_one'); ?>
                        </div>
                        <div class="main-slider__one-item__shape-2">
                            <?php ogency_elementor_rendered_image($slider, 'shape_two'); ?>
                        </div>
                        <!-- image-layer end -->
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-8">
                                    <div class="main-slider__one-item__content">
                                        <?php
                                        if (!empty($slider['title'])) :
                                            ogency_basic_rendered_content($this, $slider,  'title', '', $slider['title_tag_layout_one']);
                                        endif;
                                        ?>
                                        <a href="<?php echo esc_url($slider['url']['url']); ?>" class="main-slider__one-item__content-curved-circle-box">
                                            <?php
                                            if (!empty($slider['curved_text'])) : ?>
                                                <div class="curved-circle">
                                                    <!-- curved-circle start-->
                                                    <span class="curved-circle--item">
                                                        <?php
                                                        echo esc_html($slider['curved_text']);
                                                        ?>
                                                    </span>
                                                </div><!-- curved-circle end-->
                                            <?php endif; ?>
                                            <div class="main-slider__one-item__content-arrow-down">
                                                <span class="icon-down-right"></span>
                                            </div><!-- curved-circle icon -->
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div><!-- slider item end -->
            <?php endforeach; ?>
        </div>
        <!-- social start -->
        <div class="main-slider__socails">
            <?php foreach ($settings['layout_one_social_icons'] as $social_icon) : ?>
                <a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?></a>
            <?php endforeach; ?>
        </div>
        <!-- social end -->
        <?php
        if (!empty($settings['layout_one_phone_number'])) : ?>
            <!-- phone start -->
            <div class="main-slider__phone"><?php echo wp_kses($settings['layout_one_phone_number'], 'ogency_allowed_tags'); ?></div>
        <?php endif; ?>
        <!-- phone end -->
    </section>
    <!--Main Slider End-->
<?php endif; ?>