<?php if ('layout_three' == $settings['layout_type']) : ?>

	<!--Blog Three Start-->
	<section class="blog-page three">
		<div class="container">
			<div class="blog-page__carousel ogency-owl__dots ogency-owl__carousel owl-theme owl-carousel" data-owl-options='<?php echo esc_attr(ogency_get_owl_options($settings)); ?>'>
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				$i = 1;

				while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$comments_number = get_comments_number();
					$user = wp_get_current_user();
					$author_id = get_the_author_meta('ID');
					$author_img = get_avatar_url($author_id, array("size" => 40));
					$tag_name = get_the_tags();
				?>
					<div class="item">
						<div class="blog-one__item">
							<?php if (has_post_thumbnail()) : ?>
								<div class="blog-one__item__image">
									<?php the_post_thumbnail('ogency_blog_370X316'); ?>
									<a href="<?php the_permalink(); ?>"></a>
									<span><?php echo get_the_date(); ?></span>
								</div><!-- /.blog-image -->
							<?php endif; ?>
							<div class="blog-one__item__content">
								<?php if (has_tag() || !empty(get_comments_number())) : ?>
									<div class="blog-one__item__meta has-border">
										<?php if (has_tag()) : ?>
											<a href="<?php the_permalink(); ?>"><?php echo esc_html($tag_name[0]->name); ?></a>
										<?php endif; ?>
										<?php if (!empty(get_comments_number())) : ?>
											<span class="dot">.</span><?php ogency_comment_count(); ?>
										<?php endif; ?>
									</div><!-- /.blog-meta -->
								<?php endif; ?>
								<h3 class="blog-one__item__title">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
								</h3><!-- /.blog-title -->
								<a class="blog-one__item__btn" href="<?php the_permalink(); ?>"><?php echo esc_html($settings['read_more']); ?><?php \Elementor\Icons_Manager::render_icon($settings['blog_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a><!-- /.blog-read-more -->
							</div><!-- /.blog-content -->
						</div><!-- /.blog-card-one -->
					</div>
				<?php $i++;
				endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php ogency_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!--Blog Three End-->

<?php endif; ?>