<?php

$this->start_controls_section(
    'layout_one_content',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two']
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'ogency-addon'),
        'default' => __('Default Sub Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Sub Title', 'h5', 'layout_one');

$team = new \Elementor\Repeater();

$team->add_control(
    'name',
    [
        'label' => __('Name', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Michale smith', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($team, 'Team Name', 'h3', 'layout_one');

$team->add_control(
    'designation',
    [
        'label' => __('Designation', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Mayor', 'ogency-addon'),
    ]
);

$team->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);

$team->add_control(
    'social_network',
    [
        'label' => __('Social NetWork', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<a href="https://www.twitter.com"><i class="fab fa-twitter"></i></a>', 'ogency_allowed_tags')
    ]
);


$team->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);


$this->add_control(
    'team_items',
    [
        'label' => __('Team', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $team->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ name }}}',
    ]
);

$this->end_controls_section();
