<?php

$this->start_controls_section(
    'content_section_two',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'sec_title_two',
    [
        'label' => __('Add Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h4', 'layout_two');

$this->add_control(
    'call_text_two',
    [
        'label' => __('Add Call Text', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Call Anytime', 'ogency-addon'),
    ]
);

$this->add_control(
    'phone_number_two',
    [
        'label' => __('Phone Number', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<a href="tel:9288009850">+92 (8800) - 9850</a>', 'ogency_allowed_tags')
    ]
);

$this->add_control(
    'sec_icon_two',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-call',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'background_image_two',
    [
        'label' => __('Background Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
