<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'title',
    [
        'label' => __('Add Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Title', 'h3', 'layout_one');

$this->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Button Label', 'ogency-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'label_block' => true,
    ]
);

$this->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'shape',
    [
        'label' => __('Shape', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->end_controls_section();
