<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Slider Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$layout_two_sliders = new \Elementor\Repeater();

$layout_two_sliders->add_control(
    'title_before',
    [
        'label' => __('Title Before', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'ogency-addon'),
        'default' => __('Title Before', 'ogency-addon'),
    ]
);

$layout_two_sliders->add_control(
    'title_after',
    [
        'label' => __('Title After', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add paragraph text', 'ogency-addon'),
        'default' => __('Title After', 'ogency-addon'),
    ]
);

$layout_two_sliders->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$layout_two_sliders->add_control(
    'video_url',
    [
        'label' => __('Video Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);


$layout_two_sliders->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-down-right',
            'library' => 'font-awesome',
        ],
    ]
);

$layout_two_sliders->add_control(
    'background_image',
    [
        'label' => __('Background Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_two_sliders->add_control(
    'overlay_image',
    [
        'label' => __('Overlay Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_two_sliders->add_control(
    'video_image',
    [
        'label' => __('Video Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_two_sliders',
    [
        'label' => __('Main Slider', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_sliders->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title_before }}}',
    ]
);

$this->end_controls_section();
