<?php

$this->start_controls_section(
    'logo_section',
    [
        'label' => __('Site Logo', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'logo',
    [
        'label' => __('Logo', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'logo_dimension',
    [
        'label' => __('Logo Dimension', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
        'description' => __('Set Custom Logo Size.', 'ogency-addon'),
        'default' => [
            'width' => '55',
            'height' => '55',
        ],
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'nav_section',
    [
        'label' => __('Navigation', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'nav_menu',
    [
        'label' => __('Select Nav Menu', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => ogency_get_nav_menu(),
        'label_block' => true,
    ]
);

$this->end_controls_section();

//other
$this->start_controls_section(
    'others_section',
    [
        'label' => __('Others', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'search_enable',
    [
        'label' => __('Enable Search?', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'ogency-addon'),
        'label_off' => __('No', 'ogency-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$this->add_control(
    'cart_enable',
    [
        'label' => __('Enable Cart?', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'ogency-addon'),
        'label_off' => __('No', 'ogency-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'mobile_menu_section',
    [
        'label' => __('Mobile Drawer', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$this->add_control(
    'mobile_menu_logo',
    [
        'label' => __('Mobile Drawer Logo', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'mobile_email',
    [
        'label' => __('Email', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Email', 'ogency-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'mobile_phone',
    [
        'label' => __('Phone', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Phone Number', 'ogency-addon'),
        'label_block' => true,
    ]
);

$mobile_menu_social_icons = new \Elementor\Repeater();

$mobile_menu_social_icons->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => ogency_get_fa_icons(),
        'default' => 'fa-facebook-f',
        'label_block' => true,
    ]
);

$mobile_menu_social_icons->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'mobile_menu_social_icons',
    [
        'label' => __('Social Icons', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $mobile_menu_social_icons->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'social_icon' => 'fa-facebook-f',
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],
        'title_field' => '{{{ social_icon }}}',
    ]
);

$this->end_controls_section();
