<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'ogency-addon'),
        'default' => __('Default Sub Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Sub Title', 'h5', 'layout_one');

$faq = new \Elementor\Repeater();

$faq->add_control(
    'question',
    [
        'label' => __('Question', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Question', 'ogency-addon'),
        'default' => __('Default Question', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($faq, 'Question Title', 'h4', 'layout_one');

$faq->add_control(
    'answer',
    [
        'label' => __('Answer', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Answer', 'ogency-addon'),
        'default' => __('Default Answer', 'ogency-addon'),
        'label_block' => true,
    ]
);

$faq->add_control(
    'active_status',
    [
        'label' => __('Is active?', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'ogency-addon'),
        'label_off' => __('No', 'ogency-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);

$this->add_control(
    'faq_lists',
    [
        'label' => __('FAQ List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $faq->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ question }}}',
    ]
);

$this->add_control(
    'contact_box_image',
    [
        'label' => __('Contact Box Background Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'contact_box_icon',
    [
        'label' => __('Contact Box Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-call',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'contact_box_title',
    [
        'label' => __('Contact Box Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

$this->add_control(
    'contact_box_number_title',
    [
        'label' => __('Contact Box Number Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add number title', 'ogency-addon'),
        'default' => __('Default Number Title', 'ogency-addon'),
    ]
);

$this->add_control(
    'contact_box_number',
    [
        'label' => __('Contact Box Number', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows'  => '1',
        'placeholder' => __('Add number', 'ogency-addon'),
        'default' => __('Default Number', 'ogency-addon'),
    ]
);


$this->end_controls_section();
