<?php

//content
$this->start_controls_section(
    'content_two',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'section_title_layout_two',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title Text', 'ogency-addon'),
    ]
);

$document_list_two = new \Elementor\Repeater();

$document_list_two->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title Text', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($document_list_two, 'Document Title', 'h3', 'layout_two');

$document_list_two->add_control(
    'subtitle',
    [
        'label' => __('SubTitle', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add subtitle', 'ogency-addon'),
        'default' => __('Default Subtitle Text', 'ogency-addon'),
    ]
);

$document_list_two->add_control(
    'icon_one',
    [
        'label' => __('Check Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-download-circular-button',
            'library' => 'font-awesome',
        ],
    ]
);

$document_list_two->add_control(
    'icon_two',
    [
        'label' => __('Check Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-pdf-file',
            'library' => 'font-awesome',
        ],
    ]
);

$document_list_two->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'document_list_two',
    [
        'label' => __('Document Lists', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $document_list_two->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_two_bac_image',
    [
        'label' => __('Background Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
