<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$counter_list = new \Elementor\Repeater();

$counter_list->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($counter_list, 'Counter Title', 'h3', 'layout_one');

$counter_list->add_control(
    'number',
    [
        'label' => __('Number', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Number', 'ogency-addon'),
        'default' => __('680', 'ogency-addon'),
    ]
);

$counter_list->add_control(
    'symbol',
    [
        'label' => __('Symbol', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Symbol', 'ogency-addon'),
        'default' => __('k', 'ogency-addon'),
    ]
);

$counter_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-complete',
            'library' => 'custom-icon',
        ],
    ]
);


$this->add_control(
    'counter_list',
    [
        'label' => __('Count Lists', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $counter_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
