<?php

$this->start_controls_section(
    'content_top_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$layout_one_info_items = new \Elementor\Repeater();

$layout_one_info_items->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Title', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($layout_one_info_items, 'Title', 'h3', 'layout_one');

$layout_one_info_items->add_control(
    'content',
    [
        'label' => __('Content', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'label_block' => true,
        'default' => wp_kses(__(' <a href="mailto:needhelp@company.com">needhelp@company.com</a>
        <a href="tel:+92880048720">+92 (8800) 48720</a>'), 'ogency_allowed_tags')
    ]
);

$layout_one_info_items->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-place',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_one_info_items',
    [
        'label' => __('Contact Info', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_info_items->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
