<?php

//content
$this->start_controls_section(
    'layout_four_content',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_four'
        ]
    ]
);


$this->add_control(
    'layout_four_sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h2', 'layout_four');


$this->add_control(
    'layout_four_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'ogency-addon'),
        'default' => __('Default Sub Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_four');

$this->add_control(
    'layout_four_summary',
    [
        'label' => __('Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Summary', 'ogency-addon'),
        'default' => __('Default Summary', 'ogency-addon'),
    ]
);

$this->add_control(
    'layout_four_feature_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$layout_four_check_list = new \Elementor\Repeater();

$layout_four_check_list->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
        'label_block' => true
    ]
);


$layout_four_check_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fa fa-check',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_four_check_list',
    [
        'label' => __('Check Lists', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_four_check_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$layout_four_features_list = new \Elementor\Repeater();

$layout_four_features_list->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
        'label_block' => true
    ]
);


$layout_four_features_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-team',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_four_features_list',
    [
        'label' => __('Feature Lists', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_four_features_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_four_button_label',
    [
        'label' => __('Button Label', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Make an Appointment', 'ogency-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'layout_four_button_url',
    [
        'label' => __('Button Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'layout_four_section_image',
    [
        'label' => __('Images', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_four'
        ]
    ]
);

$this->add_control(
    'layout_four_image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->end_controls_section();
