<?php

namespace Layerdrops\Ogency\Widgets;


class Team extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-team';
    }

    public function get_title()
    {
        return __('Team', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    'layout_three' => __('Layout Three', 'ogency-addon'),
                    'layout_four' => __('Layout Four', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include ogency_get_elementor_option('team-one-option.php');
        include ogency_get_elementor_option('team-three-option.php');
        include ogency_get_elementor_option('team-four-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
        ogency_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two']);

        ogency_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .team-one__item__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        ogency_elementor_general_style_options($this, 'Designation', '{{WRAPPER}} .team-one__item__designation', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        $this->end_controls_section();

        ogency_elementor_column_count_options($this, ['layout_one', 'layout_two', 'layout_three']);
        ogency_get_elementor_carousel_options($this, ['layout_four']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('team-one.php');
        include ogency_get_template('team-two.php');
        include ogency_get_template('team-three.php');
        include ogency_get_template('team-four.php');
    }
}
