<?php

namespace Layerdrops\Ogency\Widgets;


class SidebarDownload extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'sidebar-download';
    }

    public function get_title()
    {
        return __('Sidebar Download', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $download_items = new \Elementor\Repeater();

        $download_items->add_control(
            'title',
            [
                'label' => __('Title', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Control Self Esteem', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        ogency_elementor_heading_option($download_items, 'Title', 'h3', 'layout_one');

        $download_items->add_control(
            'url',
            [
                'label' => __('File Url', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'ogency-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $download_items->add_control(
            'file_size',
            [
                'label' => __('File Size', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('3.9KB', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'download_items',
            [
                'label' => __('Download Items', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $download_items->get_controls(),
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .services-details__document__title', ['layout_one']);
        ogency_elementor_general_style_options($this, 'File Size', '{{WRAPPER}} .services-details__document__text', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('sidebar-download-one.php');
    }
}
