<?php

namespace Layerdrops\Ogency\Widgets;


class SidebarCaseInfo extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'sidebar-case-info';
    }

    public function get_title()
    {
        return __('Sidebar Contact Info', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $contact_info = new \Elementor\Repeater();

        $contact_info->add_control(
            'title',
            [
                'label' => __('Title', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Clients:', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        $contact_info->add_control(
            'content',
            [
                'label' => __('Content', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Mike Hardson', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'contact_info',
            [
                'label' => __('Contact Info', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $contact_info->get_controls(),
            ]
        );


        $this->add_control(
            'sidebar_contact_info-hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $social_icons = new \Elementor\Repeater();

        $social_icons->add_control(
            'social_icon',
            [
                'label' => __('Select Icon', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'brand',
                ],
                'label_block' => true,
            ]
        );

        $social_icons->add_control(
            'social_url',
            [
                'label' => __('Add Url', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'ogency-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'social_icons',
            [
                'label' => __('Social Icons', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $social_icons->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'social_url' => [
                            'url' => '#',
                            'is_external' => false,
                            'nofollow' => false,
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Info Title', '{{WRAPPER}} .project-details__info-list li span', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Info Content', '{{WRAPPER}} .project-details__info-list li', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('sidebar-case-info-one.php');
    }
}
