<?php

namespace Layerdrops\Ogency\Widgets;


class Shop extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-shop';
    }

    public function get_title()
    {
        return __('Shop', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include  ogency_get_elementor_option('shop-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Product Title', '{{WRAPPER}} .product__item__title a', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Product Price', '{{WRAPPER}} .product__item__price', ['layout_one']);

        $this->end_controls_section();

        //Button Style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .hot-products__content .hot-products__btn-box .thm-btn::before,{{WRAPPER}} .hot-product-three__btn-box .thm-btn::before', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        $this->end_controls_section();

        ogency_get_elementor_carousel_options($this, ['layout_one']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('shop-one.php');
    }
}
