<?php

namespace Layerdrops\Ogency\Widgets;


class Service extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-service';
    }

    public function get_title()
    {
        return __('Service', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    'layout_three' => __('Layout Three', 'ogency-addon'),
                    'layout_four' => __('Layout Four', 'ogency-addon'),
                    'layout_five' => __('Layout Five', 'ogency-addon'),
                    'layout_six' => __('Layout Six', 'ogency-addon'),
                    'layout_seven' => __('Layout Seven', 'ogency-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include ogency_get_elementor_option('service-one-option.php');
        include ogency_get_elementor_option('service-two-option.php');
        include ogency_get_elementor_option('service-three-option.php');
        include ogency_get_elementor_option('service-four-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        ogency_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline.section-title__tagline--has-dots', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        ogency_elementor_general_style_options($this, 'Section Summary', '{{WRAPPER}} .service-three__text', ['layout_three']);

        ogency_elementor_general_style_options($this, 'Service Title', '{{WRAPPER}} .service-one__item__title a,{{WRAPPER}} .service-two__item__title a,{{WRAPPER}} .service-three__item__normal__title,{{WRAPPER}} .service-three__item__hover__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven']);
        ogency_elementor_general_style_options($this, 'Service Summary', '{{WRAPPER}} .service-one__item__text,{{WRAPPER}} .service-two__item__text,{{WRAPPER}} .service-three__item__hover__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven']);
        ogency_elementor_general_style_options($this, 'Rear More Text', '{{WRAPPER}} .service-one__item__btn,{{WRAPPER}} .service-three__item__hover__btn', ['layout_one', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven']);

        $this->end_controls_section();
        ogency_elementor_column_count_options($this, ['layout_one', 'layout_three', 'layout_four', 'layout_five']);
        ogency_get_elementor_carousel_options($this, ['layout_six', 'layout_seven']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('service-one.php');
        include ogency_get_template('service-two.php');
        include ogency_get_template('service-three.php');
        include ogency_get_template('service-four.php');
        include ogency_get_template('service-five.php');
        include ogency_get_template('service-six.php');
        include ogency_get_template('service-seven.php');
    }
}
