<?php

namespace Layerdrops\Ogency\Widgets;


class Pricing extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-pricing';
    }

    public function get_title()
    {
        return __('Pricing', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include ogency_get_elementor_option('pricing-one-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline.section-title__tagline--has-dots', ['layout_one']);

        ogency_elementor_general_style_options($this, 'Heading', '{{WRAPPER}} .pricing-one__main-tab-box .tab-buttons .tab-btn span', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Active Heading', '{{WRAPPER}} .pricing-one__main-tab-box .tab-buttons .tab-btn.active-btn span', ['layout_one']);

        ogency_elementor_general_style_options($this, 'Plan Title', '{{WRAPPER}} .pricing-one__price-sub-title', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Price', '{{WRAPPER}} .pricing-one__item__price', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Service List', '{{WRAPPER}} .pricing-one__item__list li', ['layout_one']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_one']
                ]
            ]
        );

        ogency_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .ogency-btn', '{{WRAPPER}} .ogency-btn:after', ['layout_one']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('pricing-one.php');
    }
}
