<?php

namespace Layerdrops\Ogency\Widgets;


class Login extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-login';
    }

    public function get_title()
    {
        return __('Login', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Login ', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'user_name_placeholder',
            [
                'label' => __('Placeholder for username', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Username or Email Address* ', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'password_placeholder',
            [
                'label' => __('Placeholder for Password', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Password* ', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'remember_me_text',
            [
                'label' => __('Remember Me Text', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Remember Me?', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'login_btn_text',
            [
                'label' => __('Login Button Text', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Login', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'forget_text',
            [
                'label' => __('Forgot Password Text', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Forgot your Password?', 'ogency-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'forget_url',
            [
                'label' => __('Forgot Password Url', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'ogency-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .login-page__title', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Remember Me', '{{WRAPPER}} .login-page__form .checked-box label', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Forgot Password', '{{WRAPPER}} .login-page__form-forgot-password a', ['layout_one']);

        ogency_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .thm-btn', '{{WRAPPER}} .thm-btn::before', ['layout_one']);
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('login-one.php');
    }
}
