<?php

namespace Layerdrops\Ogency\Widgets;


class Header extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-header';
    }

    public function get_title()
    {
        return __('Header', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout Type', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                    'layout_three' => __('Layout Three', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include ogency_get_elementor_option('header-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Menu', '{{WRAPPER}} .main-menu .main-menu__list > li > a,{{WRAPPER}} .main-menu .main-menu__list > li > ul > li > a', ['layout_one', 'layout_two', 'layout_three']);
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('header.php');
    }
}
