<?php

namespace Layerdrops\Ogency\Widgets;


class FloorPlan extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-floor-plan';
    }

    public function get_title()
    {
        return __('Floor Plan', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include ogency_get_elementor_option('floor-plan-one-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Section Summary', '{{WRAPPER}} .floor-plan__top-text', ['layout_one']);

        ogency_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .floor-plan__main-tab-box .tab-buttons .tab-btn span', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .floor-plan__tab-content-details li p', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Content', '{{WRAPPER}} .floor-plan__tab-content-details li span', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('floor-plan-one.php');
    }
}
