<?php

namespace Layerdrops\Ogency\Widgets;


class ChooseUs extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'ogency-choose-us';
    }

    public function get_title()
    {
        return __('Choose Us', 'ogency-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['ogency-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'ogency-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'ogency-addon'),
                    'layout_two' => __('Layout Two', 'ogency-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include ogency_get_elementor_option('choose-us-one-option.php');
        include ogency_get_elementor_option('choose-us-two-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        ogency_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
        ogency_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline.section-title__tagline--has-dots', ['layout_one', 'layout_two']);
        ogency_elementor_general_style_options($this, 'Section Summary', '{{WRAPPER}} .why-choose-two__right--text', ['layout_two']);

        ogency_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .why-choose__box__title,{{WRAPPER}} .why-choose-two__box__title', ['layout_one', 'layout_two']);
        ogency_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .why-choose__box__text', ['layout_one']);
        ogency_elementor_general_style_options($this, 'Curved Circle Text', '{{WRAPPER}} .why-choose__image .video-one__banner__curved-circle-box .curved-circle', ['layout_one']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'ogency-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_two']
                ]
            ]
        );

        ogency_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .ogency-btn', '{{WRAPPER}} .ogency-btn:before', ['layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include ogency_get_template('choose-us-one.php');
        include ogency_get_template('choose-us-two.php');
    }
}
