<?php if ('layout_one' === $settings['layout_type']) : ?>
    <!--Testimonial Start-->
    <section class="testimonial-one" style="background-image: url(<?php echo esc_url($settings['layout_one_shape']['url']); ?>);">
        <div class="container">
            <div class="testimonial-one__carousel ogency-owl__carousel owl-theme owl-carousel" data-owl-options='<?php echo esc_attr(ogency_get_owl_options($settings)); ?>'>
                <?php foreach ($settings['testimonials'] as $index => $item) :  ?>
                    <!-- Testimonial Item -->
                    <div class="testimonial-one__item">
                        <div class="testimonial-one__item__author-thumb">
                            <?php ogency_elementor_rendered_image($item, 'image'); ?>
                            <span>“</span><!-- testimonial-quote-icon -->
                        </div><!-- testimonial-author-thumb -->
                        <div class="testimonial-one__item__content">
                            <div class="testimonial-one__item__quote">
                                <?php echo esc_html($item['testimonial']); ?>
                            </div><!-- testimonial-quote -->
                            <div class="testimonial-one__item__meta"><?php echo wp_kses($item['name'], 'ogency_allowed_tags'); ?><?php echo wp_kses($item['designation'], 'ogency_allowed_tags'); ?></div><!-- testimonial-meta -->
                        </div><!-- testimonial-content -->
                    </div>
                    <!-- Testimonial Item -->
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <!--Testimonial End-->

<?php endif; ?>