<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!-- Team One Start -->
	<section class="team-one">
		<div class="container-fluid">
			<?php if (!empty($settings['sec_sub_title'] || $settings['sec_title'])) : ?>
				<div class="row">
					<div class="col-md-12">
						<div class="section-title text-center">
							<?php
							if (!empty($settings['sec_sub_title'])) :
								$this->add_inline_editing_attributes('sec_sub_title', 'none');
								ogency_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline section-title__tagline--has-dots', $settings['section_sub_title_tag_layout_one']);
							endif;

							if (!empty($settings['sec_title'])) :
								$this->add_inline_editing_attributes('sec_title', 'none');
								ogency_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
							endif;
							?>
						</div><!-- section-title -->
					</div>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php
				foreach ($settings['team_items'] as $index => $item) : ?>
					<div class="col-xl-3 col-md-6 wow fadeInUp animated" data-wow-delay="<?php echo esc_attr($index); ?>00ms">
						<div class="team-one__item">
							<div class="team-one__item__image">
								<?php ogency_elementor_rendered_image($item, 'image'); ?>
							</div><!-- /.team-image -->
							<div class="team-one__item__content">
								<?php
								if (!empty($item['designation'])) :
									ogency_basic_rendered_content($this, $item,  'designation', 'team-one__item__designation', 'span');
								endif;
								?>
								<<?php echo esc_attr($item['team_name_tag_layout_one']); ?> class="team-one__item__title">
									<?php
									if (!empty($item['name'])) :
										ogency_basic_rendered_content($this, $item,  'name', '', 'a');
									endif;
									?>
								</<?php echo esc_attr($item['team_name_tag_layout_one']); ?>><!-- /.team-name -->
								<?php if (!empty($item['social_network'])) : ?>
									<div class="team-one__item__social-wrapper">
										<a class="team-one__item__links" href="#"><span class="fas fa-share-alt"></span></a><!-- /.social-more -->
										<div class="team-one__item__social">
											<?php echo wp_kses($item['social_network'], 'ogency_allowed_tags'); ?>
										</div><!-- /.team-social -->
									</div>
								<?php endif; ?>
							</div><!-- /.team-content -->
						</div><!-- /.team-one -->
					</div>
				<?php
				endforeach; ?>
			</div>
		</div>
	</section>
	<!-- Team One Start -->


<?php endif; ?>