<?php if ('layout_six' === $settings['layout_type']) : ?>

	<section class="service-page__carousel">
		<div class="container">
			<div class="ogency-owl__dots ogency-owl__carousel owl-theme owl-carousel" data-owl-options='<?php echo esc_attr(ogency_get_owl_options($settings)); ?>'>
				<?php foreach ($settings['service_list_one'] as $index => $item) :  ?>
					<div class="item">
						<div class="service-one__item">
							<div class="service-one__item__icon">
								<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
							</div><!-- /.service-icon -->
							<<?php echo esc_attr($item['service_title_tag_layout_one']); ?> class="service-one__item__title">
								<?php
								if (!empty($item['title'])) :
									ogency_basic_rendered_content($this, $item,  'title', '', 'a');
								endif;
								?>
							</<?php echo esc_attr($item['service_title_tag_layout_one']); ?>><!-- /.service-title -->
							<?php
							if (!empty($item['summary'])) :
								ogency_basic_rendered_content($this, $item,  'summary', 'service-one__item__text', 'p');
							endif;
							?>
							<?php if ($item['url']['url']) : ?>
								<a class="service-one__item__btn" href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?><?php \Elementor\Icons_Manager::render_icon($item['btn_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a><!-- /.service-read-more -->
							<?php endif; ?>
						</div><!-- /.service-card-one -->
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</section>

<?php endif; ?>