<?php if ('layout_seven' === $settings['layout_type']) : ?>
	<!--Services Seven Page Start-->
	<section class="service-page__carousel">
		<div class="container">
			<div class="ogency-owl__dots ogency-owl__carousel owl-theme owl-carousel" data-owl-options='<?php echo esc_attr(ogency_get_owl_options($settings)); ?>'>
				<?php
				$i = 1;
				foreach ($settings['layout_three_service_items'] as $index => $item) :
				?>
					<div class="item">
						<div class="service-three__item">
							<div class="service-three__item__thumb">
								<?php ogency_elementor_rendered_image($item, 'image'); ?>
							</div><!-- /.service-image -->
							<div class="service-three__item__normal">
								<?php
								if (!empty($item['title'])) :
									ogency_basic_rendered_content($this, $item,  'title', 'service-three__item__normal__title', $item['service_title_tag_layout_three']);
								endif;
								?>
							</div><!-- /.service-normal-content -->
							<div class="service-three__item__hover">
								<<?php echo esc_attr($item['service_title_tag_layout_three']); ?> class="service-three__item__hover__title">
									<?php
									if (!empty($item['title'])) :
										ogency_basic_rendered_content($this, $item,  'title', '', 'a');
									endif;
									?>
								</<?php echo esc_attr($item['service_title_tag_layout_three']); ?>><!-- /.service-title -->
								<?php
								if (!empty($item['subtitle'])) :
									ogency_basic_rendered_content($this, $item,  'subtitle', 'service-three__item__hover__text', 'p');
								endif;
								?>
								<?php if (!empty($item['btn_text'])) : ?>
									<a class="service-three__item__hover__btn" href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['btn_text']); ?><?php \Elementor\Icons_Manager::render_icon($item['btn_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a><!-- /.service-read-more -->
								<?php endif; ?>
							</div><!-- /.service-hover-content -->
						</div><!-- /.service-card-three -->
					</div>
				<?php
				endforeach; ?>
			</div>
		</div>
	</section>
	<!--Services Seven Page End-->
<?php endif; ?>