<?php if ('layout_one' === $settings['layout_type']) : ?>
	<!-- Service Start -->
	<section class="service-one @@extraClassName">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="section-title text-center">
						<?php
						if (!empty($settings['layout_one_sec_sub_title'])) :
							$this->add_inline_editing_attributes('layout_one_sec_sub_title', 'none');
							ogency_elementor_rendered_content($this, 'layout_one_sec_sub_title', 'section-title__tagline section-title__tagline--has-dots', $settings['section_sub_title_tag_layout_one']);
						endif;

						if (!empty($settings['layout_one_sec_title'])) :
							$this->add_inline_editing_attributes('layout_one_sec_title', 'none');
							ogency_elementor_rendered_content($this, 'layout_one_sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
						endif;
						?>
					</div><!-- section-title -->
				</div>
			</div>
			<div class="row">
				<?php foreach ($settings['service_list_one'] as $index => $item) :  ?>
					<div class="col-lg-3 col-md-6 wow fadeInUp animated" data-wow-delay="<?php echo esc_attr($index + 1); ?>00ms">
						<div class="service-one__item">
							<div class="service-one__item__icon">
								<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
							</div><!-- /.service-icon -->
							<<?php echo esc_attr($item['service_title_tag_layout_one']); ?> class="service-one__item__title">
								<?php
								if (!empty($item['title'])) :
									ogency_basic_rendered_content($this, $item,  'title', '', 'a');
								endif;
								?>
							</<?php echo esc_attr($item['service_title_tag_layout_one']); ?>><!-- /.service-title -->
							<?php
							if (!empty($item['summary'])) :
								ogency_basic_rendered_content($this, $item,  'summary', 'service-one__item__text', 'p');
							endif;
							?>
							<?php if ($item['url']['url']) : ?>
								<a class="service-one__item__btn" href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?><?php \Elementor\Icons_Manager::render_icon($item['btn_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a><!-- /.service-read-more -->
							<?php endif; ?>
						</div><!-- /.service-card-one -->
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</section>
	<!-- Service Start -->
<?php endif; ?>