<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- Pricing Start -->
    <section class="pricing-one">
        <div class="container">
            <?php if (!empty($settings['sec_sub_title'] || $settings['sec_title'])) : ?>
                <div class="section-title text-center">
                    <?php
                    if (!empty($settings['sec_sub_title'])) :
                        $this->add_inline_editing_attributes('sec_sub_title', 'none');
                        ogency_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline section-title__tagline--has-dots', $settings['section_sub_title_tag_layout_one']);
                    endif;

                    if (!empty($settings['sec_title'])) :
                        $this->add_inline_editing_attributes('sec_title', 'none');
                        ogency_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
                    endif;
                    ?>
                </div><!-- section-title -->
            <?php endif; ?>
            <div class="pricing-one__main-tab-box tabs-box">
                <ul class="tab-buttons list-unstyled">
                    <li data-tab="#monthly" class="tab-btn"><span><?php echo wp_kses($settings['monthly_heading'], 'ogency_allowed_tags'); ?></span></li>
                    <li data-tab="#yearly" class="tab-btn active-btn"><span><?php echo wp_kses($settings['yearly_heading'], 'ogency_allowed_tags'); ?></span></li>
                </ul><!-- pricing-tab -->
                <div class="tabs-content">
                    <!--month-tab-start-->
                    <div class="tab" id="monthly">
                        <div class="row">
                            <?php foreach ($settings['pricing_monthly_list'] as $index => $item) :  ?>
                                <!--pricing-column-start-->
                                <div class="col-lg-4 col-md-6 fadeInUp animated" data-wow-delay="<?php echo esc_attr($index + 1); ?>00ms">
                                    <!--pricing-item-start-->
                                    <div class="pricing-one__item text-center">
                                        <?php
                                        if (!empty($item['plan_title'])) :
                                            ogency_basic_rendered_content($this, $item,  'plan_title', 'pricing-one__item__title', $item['plan_title_tag_layout_one']);
                                        endif;
                                        ?>
                                        <!--pricing-item-title-->
                                        <div class="pricing-one__item__icon">
                                            <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                        </div>
                                        <!--pricing-item-icon-->
                                        <?php
                                        if (!empty($item['price'])) :
                                            ogency_basic_rendered_content($this, $item,  'price', 'pricing-one__item__price', 'h3');
                                        endif;
                                        ?>
                                        <!--pricing-item-price-->
                                        <div class="pricing-one__item__border"></div>
                                        <!--pricing-price-border-->
                                        <?php
                                        if (!empty($item['service_title'])) :
                                            ogency_basic_rendered_content($this, $item,  'service_title', 'pricing-one__item__list-title', 'h5');
                                        endif;
                                        ?>
                                        <!--pricing-item-list-title-->
                                        <ul class="pricing-one__item__list">
                                            <?php echo wp_kses($item['service_list'], 'ogency_allowed_tags'); ?>
                                        </ul>
                                        <!--pricing-item-list-->
                                        <?php
                                        if (!empty($item['button_label'])) :
                                            ogency_basic_rendered_content($this, $item,  'button_label', 'ogency-btn', 'a');
                                        endif;
                                        ?>
                                    </div>
                                    <!--pricing-item-end-->
                                </div>
                                <!--pricing-column-end-->
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <!--month-tab-end-->

                    <!--month-tab-start-->
                    <div class="tab active-tab" id="yearly">
                        <div class="row">
                            <?php foreach ($settings['pricing_yearly_list'] as $index => $item) :  ?>
                                <!--pricing-column-start-->
                                <div class="col-lg-4 col-md-6 fadeInUp animated" data-wow-delay="<?php echo esc_attr($index + 1); ?>00ms">
                                    <!--pricing-item-start-->
                                    <div class="pricing-one__item text-center">
                                        <?php
                                        if (!empty($item['plan_title'])) :
                                            ogency_basic_rendered_content($this, $item,  'plan_title', 'pricing-one__item__title', $item['plan_title_tag_layout_one']);
                                        endif;
                                        ?>
                                        <!--pricing-item-title-->
                                        <div class="pricing-one__item__icon">
                                            <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                        </div>
                                        <!--pricing-item-icon-->
                                        <?php
                                        if (!empty($item['price'])) :
                                            ogency_basic_rendered_content($this, $item,  'price', 'pricing-one__item__price', 'h3');
                                        endif;
                                        ?>
                                        <!--pricing-item-price-->
                                        <div class="pricing-one__item__border"></div>
                                        <!--pricing-price-border-->
                                        <?php
                                        if (!empty($item['service_title'])) :
                                            ogency_basic_rendered_content($this, $item,  'service_title', 'pricing-one__item__list-title', 'h5');
                                        endif;
                                        ?>
                                        <!--pricing-item-list-title-->
                                        <ul class="pricing-one__item__list">
                                            <?php echo wp_kses($item['service_list'], 'ogency_allowed_tags'); ?>
                                        </ul>
                                        <!--pricing-item-list-->
                                        <?php
                                        if (!empty($item['button_label'])) :
                                            ogency_basic_rendered_content($this, $item,  'button_label', 'ogency-btn', 'a');
                                        endif;
                                        ?>
                                    </div>
                                    <!--pricing-item-end-->
                                </div>
                                <!--pricing-column-end-->
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <!--month-tab-end-->
                </div>
            </div>
        </div>
    </section>
    <!-- Pricing Start -->


<?php endif; ?>