<?php
$search_status = $settings['search_enable'];
$cart_status = $settings['cart_enable'];
if ('layout_one' === $settings['layout_type']) : ?>

	<!-- Header Style One -->
	<header class="main-header">
		<nav class="main-menu">
			<div class="container-fluid">
				<?php if (!empty($settings['logo']['url'])) : ?>
					<div class="main-menu__logo logo-retina">
						<a href="<?php echo esc_url(home_url('/')); ?>">
							<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
						</a>
					</div><!-- /.main-menu__logo -->
				<?php endif; ?>
				<div class="main-menu__nav">
					<?php
					wp_nav_menu(
						array(
							'menu' => $settings['nav_menu'],
							'menu_class' => 'main-menu__list',
							'walker'         => class_exists('\Layerdrops\Ogency\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Ogency\Megamenu\Walker_Nav_Menu : '',
						)
					);
					?>
				</div><!-- /.main-menu__nav -->
				<div class="main-menu__right">
					<a href="#" class="main-menu__toggler mobile-nav__toggler">
						<i class="fa fa-bars"></i>
					</a><!-- /.mobile menu btn -->
					<?php
					if (('yes' == $search_status)) : ?>
						<a href="#" class="main-menu__search search-toggler">
							<i class="icon-magnifying-glass"></i>
						</a><!-- /.search btn -->
					<?php endif; ?>
					<?php if ('yes' == $cart_status && class_exists('WooCommerce')) : ?>
						<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-menu__cart cart-toggler">
							<i class="icon-shopping-cart"></i>
						</a><!-- /.cart btn -->
					<?php endif; ?>
				</div><!-- /.main-menu__right -->
			</div><!-- /.container -->
		</nav>
		<!-- /.main-menu -->
	</header>
	<!-- End Header Style One -->

	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>

<?php endif; ?>

<?php if ('layout_two' === $settings['layout_type']) : ?>

	<header class="main-header main-header-two">
		<nav class="main-menu">
			<div class="container-fluid">
				<?php if (!empty($settings['logo']['url'])) : ?>
					<div class="main-menu__logo logo-retina">
						<a href="<?php echo esc_url(home_url('/')); ?>">
							<img src="<?php echo esc_url($settings['logo']['url']); ?>" width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
						</a>
					</div><!-- /.main-menu__logo -->
				<?php endif; ?>
				<div class="main-menu__nav  main-menu__nav--two">
					<?php
					wp_nav_menu(
						array(
							'menu' => $settings['nav_menu'],
							'menu_class' => 'main-menu__list',
							'walker'         => class_exists('\Layerdrops\Ogency\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Ogency\Megamenu\Walker_Nav_Menu : '',
						)
					);
					?>
				</div><!-- /.main-menu__nav -->
				<div class="main-menu__right">
					<a href="#" class="main-menu__toggler mobile-nav__toggler">
						<i class="fa fa-bars"></i>
					</a><!-- /.mobile menu btn -->
					<?php
					if (('yes' == $search_status)) : ?>
						<a href="#" class="main-menu__search search-toggler">
							<i class="icon-magnifying-glass"></i>
						</a><!-- /.search btn -->
					<?php endif; ?>
					<?php if ('yes' == $cart_status && class_exists('WooCommerce')) : ?>
						<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-menu__cart cart-toggler">
							<i class="icon-shopping-cart"></i>
						</a><!-- /.cart btn -->
					<?php endif; ?>
				</div><!-- /.main-menu__right -->
			</div><!-- /.container -->
		</nav>
		<!-- /.main-menu -->
	</header><!-- /.main-header -->

	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu main-header-two">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>

<?php endif; ?>

<?php if ('layout_three' === $settings['layout_type']) : ?>

	<header class="main-header main-header--with-border">
		<nav class="main-menu">
			<div class="container-fluid">
				<?php if (!empty($settings['logo']['url'])) : ?>
					<div class="main-menu__logo logo-retina">
						<a href="<?php echo esc_url(home_url('/')); ?>">
							<img src="<?php echo esc_url($settings['logo']['url']); ?>" width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
						</a>
					</div><!-- /.main-menu__logo -->
				<?php endif; ?>
				<div class="main-menu__nav">
					<?php
					wp_nav_menu(
						array(
							'menu' => $settings['nav_menu'],
							'menu_class' => 'main-menu__list',
							'walker'         => class_exists('\Layerdrops\Ogency\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Ogency\Megamenu\Walker_Nav_Menu : '',
						)
					);
					?>
				</div><!-- /.main-menu__nav -->
				<div class="main-menu__right">
					<a href="#" class="main-menu__toggler mobile-nav__toggler">
						<i class="fa fa-bars"></i>
					</a><!-- /.mobile menu btn -->

					<?php
					if (('yes' == $search_status)) : ?>
						<a href="#" class="main-menu__search search-toggler">
							<i class="icon-magnifying-glass"></i>
						</a><!-- /.search btn -->
					<?php endif; ?>

					<?php if ('yes' == $cart_status && class_exists('WooCommerce')) : ?>
						<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-menu__cart cart-toggler">
							<i class="icon-shopping-cart"></i>
						</a><!-- /.cart btn -->
					<?php endif; ?>

				</div><!-- /.main-menu__right -->
			</div><!-- /.container -->
		</nav>
		<!-- /.main-menu -->
	</header><!-- /.main-header -->

	<?php if (get_theme_mod('header_sticky_menu') == 'yes' && !is_admin_bar_showing()) : ?>
		<div class="stricky-header stricked-menu main-menu main-menu-three">
			<div class="sticky-header__content"></div><!-- /.sticky-header__content -->
		</div><!-- /.stricky-header -->
	<?php endif; ?>

<?php endif; ?>

<div class="mobile-nav__wrapper">
	<div class="mobile-nav__overlay mobile-nav__toggler"></div>
	<!-- /.mobile-nav__overlay -->
	<div class="mobile-nav__content">
		<span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

		<div class="logo-box">
			<a href="<?php echo esc_url(home_url('/')); ?>" aria-label="logo image">
				<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['mobile_menu_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" />
			</a>
		</div>
		<!-- /.logo-box -->
		<div class="mobile-nav__container"></div>
		<!-- /.mobile-nav__container -->
		<ul class="mobile-nav__contact list-unstyled ml-0">
			<?php if ($settings['mobile_email']) : ?>
				<li>
					<i class="fa fa-envelope"></i>
					<a href="mailto:<?php echo esc_attr($settings['mobile_email']); ?>"><?php echo esc_html($settings['mobile_email']); ?></a>
				</li>
			<?php endif; ?>
			<?php if ($settings['mobile_phone']) : ?>
				<li>
					<i class="fa fa-phone-alt"></i>
					<a href="tel:<?php echo esc_url(str_replace(' ', '-', $settings['mobile_phone'])); ?>">
						<?php echo esc_html($settings['mobile_phone']); ?>
					</a>
				</li>
			<?php endif; ?>
		</ul><!-- /.mobile-nav__contact -->
		<div class="mobile-nav__top">
			<div class="mobile-nav__social">
				<?php foreach ($settings['mobile_menu_social_icons'] as $social_icon) : ?>
					<a href="<?php echo esc_url($social_icon['social_url']['url']); ?>" class="fab <?php echo esc_attr($social_icon['social_icon']); ?>"></a>
				<?php endforeach; ?>
			</div><!-- /.mobile-nav__social -->
		</div><!-- /.mobile-nav__top -->

	</div>
	<!-- /.mobile-nav__content -->
</div>

<div class="search-popup">
	<div class="search-popup__overlay search-toggler"></div>
	<!-- /.search-popup__overlay -->
	<div class="search-popup__content">
		<form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
			<label for="search" class="sr-only"><?php echo esc_html__("search here", 'ogency-addon'); ?></label><!-- /.sr-only -->
			<input type="text" name="s" id="search" value="<?php echo esc_attr(get_search_query()); ?>" placeholder="<?php echo esc_attr__('Search Here...', 'ogency-addon') ?>" />
			<button type="submit" aria-label="search submit" class="ogency-btn">
				<i class="icon-magnifying-glass"></i>
			</button>
		</form>
	</div>
	<!-- /.search-popup__content -->
</div>
<!-- /.search-popup -->

<?php $ogency_back_to_top_status = get_theme_mod('scroll_to_top', 'no'); ?>
<?php if ('yes' === $ogency_back_to_top_status) : ?>
	<a href="#" class="scroll-top">
		<svg class="scroll-top__circle" width="100%" height="100%" viewBox="-1 -1 102 102">
			<path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
		</svg>
	</a>
<?php endif; ?>