<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- Feature Start -->
    <section class="feature-one">
        <div class="container">
            <div class="row">
                <?php foreach ($settings['feature_list_one'] as $index => $item) :  ?>
                    <div class="col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="<?php echo esc_attr($index + 1); ?>00ms">
                        <div class="feature-one__item">
                            <!-- feature item start -->
                            <div class="feature-one__item__img">
                                <?php ogency_elementor_rendered_image($item, 'image'); ?>
                            </div>
                            <div class="feature-one__item__content">
                                <?php
                                if (!empty($item['title'])) :
                                    $key_title = $this->get_repeater_setting_key('title', 'feature_list_one', $index);
                                    $this->add_inline_editing_attributes($key_title, 'none');
                                    ogency_elementor_repeater_rendered_content($this, $item, $key_title,  'title', 'feature-one__item__content--title', 'h4');
                                endif;
                                ?>
                                <div class="feature-one__item__content--icon">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                </div>
                            </div><!-- feature normal content -->
                            <div class="feature-one__item__hover-content">

                                <?php
                                if (!empty($item['title'])) :
                                    $key_hover_title = $this->get_repeater_setting_key('title', 'feature_list_one', $index . '-hover-title');
                                    $this->add_inline_editing_attributes($key_hover_title, 'none');
                                    ogency_elementor_repeater_rendered_content($this, $item, $key_hover_title,  'title', 'feature-one__item__hover-content--title', 'h4');
                                endif;
                                if (!empty($item['summary'])) :
                                    ogency_basic_rendered_content($this, $item,  'summary', 'feature-one__item__hover-content--text', 'p');
                                endif;
                                ?>
                                <?php if (!empty($item['url']['url'])) : ?>
                                    <a class="feature-one__item__hover-content__btn" href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['button_label']); ?><?php \Elementor\Icons_Manager::render_icon($item['btn_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a>
                                <?php endif; ?>
                            </div><!-- feature hover content -->
                        </div><!-- feature item end -->
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <!-- Feature End -->
<?php endif; ?>