<?php

//content
$this->start_controls_section(
    'layout_two_content',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);


$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'ogency-addon'),
        'default' => __('Default Sub Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_two');


$this->add_control(
    'layout_two_highlighted_text',
    [
        'label' => __('Highlighted Text', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Highlighted Text', 'ogency-addon'),
        'default' => __('Default Highlighted Text', 'ogency-addon'),
    ]
);

$this->add_control(
    'layout_two_summary',
    [
        'label' => __('Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Text', 'ogency-addon'),
        'default' => __('Default Summary Text', 'ogency-addon'),
    ]
);


$this->add_control(
    'layout_two_quotation',
    [
        'label' => __('Quotation', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Quotation', 'ogency-addon'),
        'default' => __('Default Quotation Text', 'ogency-addon'),
    ]
);

$this->add_control(
    'layout_two_button_label',
    [
        'label' => __('Button Label', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Discover More', 'ogency-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'layout_two_button_url',
    [
        'label' => __('Button Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_two_video_url',
    [
        'label' => __('Video Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('#', 'ogency-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_two_video_title',
    [
        'label' => __('Video Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Video Title', 'ogency-addon'),
        'default' => __('Default Text', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Video Caption', 'h2', 'layout_two');

$this->end_controls_section();

$this->start_controls_section(
    'layout_two_section_image',
    [
        'label' => __('Images', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_image_one',
    [
        'label' => __('Image One', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_two_image_two',
    [
        'label' => __('Image Two', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_two_bg_image',
    [
        'label' => __('Background Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_two_icon_one',
    [
        'label' => __('Icon One', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-psychology-2',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_two_icon_two',
    [
        'label' => __('Icon Two', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-brain',
            'library' => 'custom-icon',
        ],
    ]
);

$this->end_controls_section();
