<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$testimonial = new \Elementor\Repeater();

$testimonial->add_control(
    'name',
    [
        'label' => __('Name', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Kevin martin', 'ogency-addon'),
        'label_block' => true
    ]
);

$testimonial->add_control(
    'designation',
    [
        'label' => __('Designation', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Customer', 'ogency-addon'),
        'label_block' => true
    ]
);

$testimonial->add_control(
    'testimonial',
    [
        'label' => __('Testimonial', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Testimonial Content', 'ogency-addon'),
    ]
);

$testimonial->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'testimonials',
    [
        'label' => __('Testimonial Items', 'ogency-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $testimonial->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);


$this->add_control(
    'layout_one_shape',
    [
        'label' => __('Shape ', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
