<?php

$this->start_controls_section(
    'layout_four_content_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_four'
        ]
    ]
);


$this->add_control(
    'layout_four_sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h3', 'layout_four');


$layout_four_testimonial = new \Elementor\Repeater();

$layout_four_testimonial->add_control(
    'name',
    [
        'label' => __('Name', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Kevin martin', 'ogency-addon'),
        'label_block' => true
    ]
);

ogency_elementor_heading_option($layout_four_testimonial, 'Testimonial Title', 'h3', 'layout_four');

$layout_four_testimonial->add_control(
    'designation',
    [
        'label' => __('Designation', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Customer', 'ogency-addon'),
        'label_block' => true
    ]
);

$layout_four_testimonial->add_control(
    'testimonial',
    [
        'label' => __('Testimonial', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Testimonial Content', 'ogency-addon'),
    ]
);

$layout_four_testimonial->add_control(
    'rating',
    [
        'label' => __('Rating', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 5,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 5,
        ],
    ]
);

$layout_four_testimonial->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_four_testimonial->add_control(
    'quote_icon',
    [
        'label' => __('Quote Icon ', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$layout_four_testimonial->add_control(
    'shape',
    [
        'label' => __('Shape ', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->add_control(
    'layout_four_testimonials',
    [
        'label' => __('Testimonial Items', 'ogency-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_four_testimonial->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);
$this->end_controls_section();
