<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$tab_list = new \Elementor\Repeater();

$tab_list->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'ogency-addon'),
        'default' => __('Individual Therapy', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($tab_list, 'Title', 'h3', 'layout_one');

$tab_list->add_control(
    'summary',
    [
        'label' => __('Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'ogency-addon'),
        'default' => __('Default Text', 'ogency-addon'),
    ]
);

$tab_list->add_control(
    'feature',
    [
        'label' => __('Feature', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'rows' => '2',
        'placeholder' => __('Add Feature', 'ogency-addon'),
        'default' => __('<li><div class="icon"><span class="fa fa-check"></span></div><div class="text"><p>Nsectetur cing elit</p></div></li>', 'ogency-addon'),
    ]
);


$tab_list->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'tab_list',
    [
        'label' => __('Tab Lists', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $tab_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'shape',
    [
        'label' => __('Shape', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
