<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_three', 'layout_five', 'layout_seven']
        ]
    ]
);

$this->add_control(
    'layout_three_sec_title',
    [
        'label' => __('Section Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Title', 'h2', 'layout_three');

$this->add_control(
    'layout_three_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Sub Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($this, 'Section Sub Title', 'h5', 'layout_three');

$this->add_control(
    'layout_three_sec_summary',
    [
        'label' => __('Section Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Summary', 'ogency-addon'),
    ]
);

$layout_three_service = new \Elementor\Repeater();

$layout_three_service->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Awesome Title', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($layout_three_service, 'Service Title', 'h3', 'layout_three');

$layout_three_service->add_control(
    'subtitle',
    [
        'label' => __('Subtitle', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Default subtitle', 'ogency-addon'),
        'label_block' => true,
    ]
);


$layout_three_service->add_control(
    'btn_text',
    [
        'label' => __('Button Text', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'default' => __('Read More', 'ogency-addon'),
        'label_block' => true,
    ]
);

$layout_three_service->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_three_service->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
    ]
);

$layout_three_service->add_control(
    'btn_icon',
    [
        'label' => __('Url Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-arrow',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_three_service_items',
    [
        'label' => __('Service Items', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_service->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
