<?php

$this->start_controls_section(
    'layout_six_content_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_six'
        ]
    ]
);


$layout_six_service = new \Elementor\Repeater();

$layout_six_service->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Awesome Title', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($layout_six_service, 'Service Title', 'h3', 'layout_six');

$layout_six_service->add_control(
    'tag_line',
    [
        'label' => __('Tag Line', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Tag Line', 'ogency-addon'),
        'label_block' => true,
    ]
);

$layout_six_service->add_control(
    'btn_text',
    [
        'label' => __('Button Text', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'default' => __('More', 'ogency-addon'),
        'label_block' => true,
    ]
);

$layout_six_service->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
    ]
);

$layout_six_service->add_control(
    'btn_icon',
    [
        'label' => __('Url Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-arrow',
            'library' => 'custom-icon',
        ],
    ]
);

$layout_six_service->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_six_service_items',
    [
        'label' => __('Service Items', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_six_service->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
