<?php

$this->start_controls_section(
    'content__five_section',
    [
        'label' => __('Portfolio Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);


$portfolio_five = new \Elementor\Repeater();

$portfolio_five->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Title', 'ogency-addon'),
        'default' => __('Default Title', 'ogency-addon'),
    ]
);

ogency_elementor_heading_option($portfolio_five, 'Portfolio Title', 'h3', 'layout_five');

$portfolio_five->add_control(
    'summary',
    [
        'label' => __('Summary', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add summary text', 'ogency-addon'),
        'default' => __('summary text', 'ogency-addon'),
    ]
);

$portfolio_five->add_control(
    'url',
    [
        'label' => __('Url', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'ogency-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);


$portfolio_five->add_control(
    'read_more_txt',
    [
        'label' => __('Read More Text', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Read More Text', 'ogency-addon'),
        'default' => __('Read More', 'ogency-addon'),
    ]
);

$portfolio_five->add_control(
    'features',
    [
        'label' => __('Features', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'default' => wp_kses(__('<li> <p><span>Signs:</span> Low Confidence</p> </li>', 'ogency-addon'), 'ogency_allowed_tags')
    ]
);



$portfolio_five->add_control(
    'image',
    [
        'label' => __('Image', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'portfolio_five_list',
    [
        'label' => __('Portfolio List', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $portfolio_five->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
