<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'ogency-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$layout_one_icon_box = new \Elementor\Repeater();

$layout_one_icon_box->add_control(
    'title',
    [
        'label' => __('Title', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Book Appointment ', 'ogency-addon'),
        'label_block' => true,
    ]
);

ogency_elementor_heading_option($layout_one_icon_box, 'Title', 'h3', 'layout_one');

$layout_one_icon_box->add_control(
    'icon',
    [
        'label' => __('Icon', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-success',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_one_icon_box',
    [
        'label' => __('Items', 'ogency-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_icon_box->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
